/*
 *  include file for global Crestron variables
 *
 */

#ifndef _LINUX_CRESTRON_H_
#define _LINUX_CRESTRON_H_


#define TSW550 0x37
#define TSW750 0x3e
#define TST600 0x3d
#define TST900 0x3c
#define TSW1050 0x2f
#define TSM750 0x26
#define TSR300 0x3f

// The TST900 had some important changes between schematic rev. B and rev. C.
// These will allow us to tell which we are running on.

// Revision IDs for the Crestron TST-900.
typedef enum {
    TST900_HW_REV_ID    	= 0x01, // initial
    TST900_HW_REV_ID_REV_C  = 0x02, // TST900 rev. C schematic or later
    TST900_HW_REV_ID_OSC    = 0x09, // TST900 (CE) with external video oscillator
} TST900_HW_REV_ID_TYPE;

// CRESTRON_TST900 revision bitmap
#define TST900_EXT_OSCILLATOR	0x08
#define TST900_REV_C			0x02

// ProductRev for new TST602/TST902 designs using
// TI Wifi module controlled by the WIFI_ON pin.
// For testing with a modified TST600/TST900
// can substitute 0x01 or 0x09 (check Rev level of modified board)
#define REV_602_902	0x02

// Revision IDs for the Crestron TST-600, formerly known as the TPMC-6X.
// Note: HPRF radio is also referred to as ER (Extended Range) radio.
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// CRESTRON_TST600 revision bitmap
#define TST600_HW_REV_WIFIRF_MASK 0x07
#define TST600_EXT_OSCILLATOR	0x08

// CRESTRON_TST900 revision bitmap
#define TST900_HW_REV_WIFIRF_MASK 0x07
#define TST900_EXT_OSCILLATOR	0x08

// CRESTRON_ONYX7 revision bitmap
#define ONYX7_EXT_OSCILLATOR	0x01

// CRESTRON_TSW730_CS and CRESTRON_TSW730_MC revision bitmap
//#define TSW730_WHITE_LEDS		0x01
#define TSW730_EXT_OSCILLATOR	0x01

// CRESTRON_TSW550 revision bitmap
#define TSW550_EXT_OSCILLATOR	0x01

// CRESTRON_TSW1050 revision bitmap
#define TSW1050_EXT_OSCILLATOR	0x01


// TODO: Fix/unify duplication of Device Revisions in shared header file
//  "MC3/trunk/WINCE600/OSDesigns/MC3System/MC3System/Include/Internal/Shared/UIHalAPI.h"....
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
typedef enum {
    TST600_HW_REV_ID_TPMC_6X    = 0x01, // WiFi and HPRF radio.
    TST600_HW_REV_ID_TPMC_6XRF  = 0x02, // HPRF (a.k.a. "ER") radio only.
    TST600_HW_REV_ID_TPMC_6XWF  = 0x03, // WiFi only.
    TST600_HW_REV_ID_PTX6       = 0x04  // Infinite-EX radio.
} TST600_HW_REV_ID_TYPE;

// Revision IDs for the Crestron TSW-730.
typedef enum {
    TSW730_HW_REV_ID_COMM    = 0x00, // Commercial, Red/Green LED's
#if	0	// this is no longer valid.  replaced by product ID (CRESTRON_TSW730_MC_R) above
	TSW730_HW_REV_ID_RESI    = 0x01, // Residential, White LED's (TSW-731)
#endif
} TSW730_HW_REV_ID_TYPE;

//Exposed from platform to be used in audio driver
#define MIC_SEL_3V3             (1*32 + 13)     // GPIO_2_13
#define AMP_SD_N		(6*32 + 3)      /* GPIO_7_3 */
#define AMP_SD_N_TSM750		(0*32 + 4)      /* GPIO_1_4 */

extern int gProductId;
extern int gProductRev;

extern u32 crest_get_prodID(void);

enum  {
        boost=0x01,
        normal,
        half,
        low,
};

struct cpufreq {

        int CpuFreq;    //frequency
        int CpuVolt;    //voltage
        int CpuSetPt;  //setpoint
        int new_CpuFreq;
        struct mutex cpuFreqMutex; //mutex lock for gCpufreq stat
};
struct cputemp {

        int CpuTemp;    //Cpu temperature
        int PmicTemp;    //PMIC junction temperature
	struct delayed_work monitor_work;
	struct input_dev *EvInput;
        struct mutex cpuTempMutex; //mutex lock for gCpufreq stat
};

struct pm_control {

	int power_led_enable;   // 0=disabled; 1=enabled
    int battery_critical_level_thresh;      // 0-100%
    int battery_warning_level_thresh;       // 0-100%
    int warning_led_flash_rate;
    int critical_led_flash_rate;
    int charging_led_flash_rate;
    int autocharge;
    int suspendcharge;
   	unsigned int uiThresholds;
    int battery_full_capacity;
	int suspend_timer;
    unsigned long capabilities;
} ;


#endif /* _LINUX_CRESTRON_H_ */

